<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Firm extends Model 
{

    protected $table = 'cargo_firms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'website', 'phone_number');
    protected $visible = array('name', 'website', 'phone_number');

    public function integrations()
    {
        return $this->hasMany('Integration');
    }

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

}